vec2 hammersley(uint i, uint numSamples) {
    uint bits = i;
    bits = (bits << 16) | (bits >> 16);
    bits = ((bits & 0x55555555) << 1) | ((bits & 0xAAAAAAAA) >> 1);
    bits = ((bits & 0x33333333) << 2) | ((bits & 0xCCCCCCCC) >> 2);
    bits = ((bits & 0x0F0F0F0F) << 4) | ((bits & 0xF0F0F0F0) >> 4);
    bits = ((bits & 0x00FF00FF) << 8) | ((bits & 0xFF00FF00) >> 8);
    return vec2(i / numSamples, bits / exp2(32));
}

vec3 GGXVNDF(vec3 vector, vec2 offset, float alpha){
    vec3 v = normalize(vec3(alpha * vector.x, alpha * vector.y, vector.z));

    vec3 t0 = v.z < 0.9999 ? normalize(cross(v, vec3(0.0, 0.0, 1.0))) : vec3(1.0, 0.0, 0.0);
    vec3 t1 = cross(t0, v);

    float a = 1.0 / (1.0 + v.z);
    float r = sqrt(offset.x);
    float p = offset.y < a ? offset.y / a * pi : pi + (offset.y - a) / (1.0 - a) * pi;

    float p0 = r * cos(p);
    float p1 = r * sin(p) * (offset.y < a ? 1.0 : v.z);

    vec3 n = p0 * t0 + p1 * t1 + sqrt(max0(1.0 - p0 * p0 - p1 * p1)) * v;
         n = normalize(vec3(alpha * n.x, alpha * n.y, max0(n.z)));
         
    return n;
}

vec3 atmosphere(vec3 direction, vec3 up_direction, vec3 moon_direction){
    #if defined VOLUMETRIC_CLOUD || defined PLANAR_CLOUD
        vec4 clouds = texture2(colortex13, project_sphere(direction));
    #else
        vec4 clouds = vec4(0.0, 0.0, 0.0, 1.0);
    #endif

    vec3 transmittance = texture2(colortex2, project_sphere(direction)).xyz * pow4(clouds.w);

    vec3 atmosphere = texture2(colortex1, project_sphere(direction)).xyz;
         //atmosphere += texture2(colortex1, project_sphere(vec3(0.0, direction.y, 0.0))).xyz;

    #if defined VOLUMETRIC_CLOUD || defined PLANAR_CLOUD
         atmosphere = mix(atmosphere, atmosphere + atmosphere.g * 2.0, wetness);
    #endif

         atmosphere = atmosphere * clouds.w + clouds.xyz;
         atmosphere += luminance(transmittance) * stars(direction, moon_direction);

    return atmosphere;
}

mat3 tbn(vec3 n){
    vec3 c0 = cross(n, vec3(0.0, 0.0, 1.0));
    vec3 c1 = cross(n, vec3(0.0, 1.0, 0.0));

    vec3 t = length(c0) > length(c1) ? c0 : c1;
    vec3 b = cross(n, t);

    return mat3(t, b, n);
}

vec3 reflection(specular s, materials m, vec3 color, vec3 albedo, vec3 normal, vec3 view_position, vec3 position, vec3 vector, vec3 moon_direction, vec3 noise, float depth, float lightmap){
    const int steps0 = REFLECTION_QUALITY;
    const uint steps1 = 2u;

    const float z_depth = 0.2;

    lightmap = saturate(lightmap);
    //lightmap = 1.0 - pow(1.0 - lightmap, 0.7);
    lightmap = pow2(lightmap);

    if(depth >= 1) return color;
    if(s.roughness == 1) return color;

    float NdotV = abs(dot(normal, -vector));
    float alpha = pow2(s.roughness);

    vec3 reflection = vec3(0.0);
    vec3 hit_position = vec3(0.0);

    #ifdef TERRAIN_REFLECTION
        for(uint i = 0u; i < steps1; ++i){
            vec2 o = hammersley(i, steps1) + noise.xy;
            vec3 h = tbn(normal) * GGXVNDF(-vector * tbn(normal), o, alpha);
            vec3 d = reflect(vector, h);

            float LdotH = abs(dot(d, h));
            float NdotL = abs(dot(normal, d));
            float NdotH = abs(dot(normal, h));

            bool intersect = screenspace_raytrace(view_position, position, mat3(gbufferModelView) * d, NdotV, noise.x, z_depth, steps0, hit_position);

            if(intersect){
                vec3 water_scattering = texture2(colortex3, hit_position.xy * VL_LOD).xyz;
                vec3 water_transmittance = texture2(colortex4, hit_position.xy * VL_LOD).xyz;

                reflection += decodeRGBE8(texture2(colortex7, hit_position.xy));

                if(isEyeInWater == 1){
                    reflection = reflection * water_transmittance + water_scattering;
                }
            } else {
                if(isEyeInWater == 0){
                    reflection += pow4(eyeBrightnessSmooth.y / 254.0) * atmosphere(d, vec3(0.0, 1.0, 0.0), moon_direction);
                }
            }   

            reflection *= exact_correlated_g2(NdotL, NdotV, alpha * alpha);
            reflection *= fresnel(s, albedo, LdotH, m.water);
        }
        
        reflection /= float(steps1);
    #else
        vec3 d = (2.0 * NdotV) * normal + vector;

        if((s.conductor >= 230 && s.conductor <= 237) || m.translucent){
            reflection += lightmap * atmosphere(d, vec3(0.0, 1.0, 0.0), moon_direction);
            reflection *= fresnel(s, albedo, NdotV, m.water);
        }
    #endif

    //if((s.conductor >= 230 && s.conductor <= 237) || m.stained_glass || m.slime){
    //    reflection *= (1.0 - s.f0) * s.f0 + albedo;
    //}
    
    return color + reflection;
}